# require 'wrest'
require 'nokogiri'

require_relative '../rspec_helper'
require 'vaToolSet/vaToolSet_pageObject'
require_relative '../../common/accessVarUtility'
require_relative '../../pages/landing_page'

describe '[VaRut-404: Verify Authenticated User]
         [VARUT-1181: VAR Utility - Unauthorized Landing Page]
         [VARUT-1641: Select Facility Location - Pre Authorized Page View]
         [VARUT-1262: Update Generic text for unauthorized landing page]
         [VARUT-1337: Unauthorized page - text update to include Clinical Applications Coordinator]' do
  include DriverUtility
  include DateUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @landing_page = LandingPage.new(@driver)
    @home = Home.new(@driver)
    @landing_page = LandingPage.new(@driver)
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end

  after(:all) do
    @driver.close
  end



  context '[AC#VARUT-642|TC#VARUT-650: User with the SD Supervisor key, VAR Utility authorized Welcome page]
           [AC#VARUT-1744|TC#VARUT-1745: Select Facility Location - Pre Authorized Page View ]' do

    it "Login" do
      @vts_po.accessVarUtility.access_var_utility(UserAccess7)
      @vts_po.landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@vts_po.landing.rightFooter == "Logged in as PROVIDER, SEVEN"}
      expect(@vts_po.landing.rightFooter).to eq("Logged in as PROVIDER, SEVEN")
    end


    it "Verify pre authorized page - Details" do
      @vts_po.landing.welcome_message_element.when_visible(TIME_OUT_LIMIT)
      @vts_po.landing.facility_location?
      @vts_po.landing.view_settings?

      expect(@vts_po.landing.primary_header).to eq("VAR Utility - Select Facility Location")
      homeWelcomeMessage =  @vts_po.landing.welcome_message.split("\n")
      #for screen reader
      expect(homeWelcomeMessage[1]).to eq( "Welcome SEVEN PROVIDER")

      today = getDateNthDaysAgo(0, "%B %d, %Y")
      expect(homeWelcomeMessage[2]).to eq(today)
      expect(homeWelcomeMessage[3]).to eq("In order to support requests and direct scheduling options in VAR, settings for each facility location under BOSTON HCS VAMC must be individually configured.")

    end

    it "Verify Facility list is sorted" do

      expect(@landing_page.isFacilityListSorted?).to eq(true)
    end

    it "Verify Facility List" do

      expected_content =[\
                         "ZZBOSTON NURSING HOME",
                         "ZZ-DORCHESTER",
                         "WORCESTER",
                         "WEST ROXBURY",
                         "QUINCY",
                         "PLYMOUTH CBOC",
                         "LOWELL OPC",
                         "IDES HANSCOM AFB",
                         "FRAMINGHAM",
                         "CHELSEA",
                         "BROCKTON VAMC",
                         "BROCKTON DOM",
                         "BOSTON VA MOBILE CLINIC",
                         "BOSTON VA FACILITY DOM",
                         "BOSTON SPINAL CORD OUTCOMES",
                         "BOSTON SOC",
                         "BOSTON PRRTP",
                         "BOSTON HCS VAMC"
      ]

      actual_content = @landing_page.facility_location_options
      p actual_content
      compareContents(expected_content, actual_content)
    end

    it "Selecting view settings button for each facility takes user to VAR Utility page - Details" do
      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      @driver.back

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BROCKTON VAMC')
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      @driver.back

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('FRAMINGHAM')
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      @driver.back

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('QUINCY')
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      @driver.back
      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
    end

    it "Verify VAR Utility page - Details" do
      @vts_po.landing.welcome_message_element.when_visible(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@vts_po.landing.primary_header).to eq("Welcome")
      newWelcomeMessage =  @vts_po.landing.new_welcome_message.split("\n")
      expect(newWelcomeMessage[0]).to eq( "Welcome SEVEN PROVIDER")

      today = getDateNthDaysAgo(0, "%B %d, %Y")
      expect(newWelcomeMessage[1]).to eq(today)
      expect(newWelcomeMessage[2]).to eq("You are viewing settings for:")
      expect(newWelcomeMessage[3]).to eq("BOSTON HCS VAMC")
      expect(newWelcomeMessage[4]).to eq("Note that any changes to this location's settings affect all clinics associated with this location.")
    end

    it "Verify selecting the home icon returns users to the VA Tool Set home page" do
      @vts_po.base.home_btn_element.click
      @vts_po.home.primary_header_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.primary_header).to eq("Home")
    end

  end

  context 'AC#VARUT-642|TC#VARUT-650: User without the needed SD Supervisor key, VAR Utility unauthorized Welcome page
           AC#VARUT-128|TC#VARUT-129:Utility - Validate user authorizatino to access VAR Utility
           AC#VARUT-1228|TC#VARUT-1229: Test VAR Utility - Unauthorized Landing Page
           AC#VARUT-1275|TC#VARUT-1276: Validate Generic text for unauthorized landing page
           AC#VARUT-1425|TC#VARUT-1426: Verify Unauthorized page text update to include Clinical Applications Coordinator' do

    it "Login and access VAR Utility" do
      @vts_po.accessVarUtility.logout_login_ends_on_var_utility(UserAccess70)
      @vts_po.landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)

      Watir::Wait.until {@vts_po.landing.rightFooter == "Logged in as PROVIDER, SEVENTY"}
      expect(@vts_po.landing.rightFooter).to eq("Logged in as PROVIDER, SEVENTY")

    end

    it "Verify VAR Utility page - Unauthorized landing page" do
      time_date = Time.now.strftime('%B %d, %Y')

      @vts_po.landing.unauthorized_welcome_message_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.landing.title).to eq("VA Tool Set")
      expect(@vts_po.landing.primary_header).to eq("VAR Utility")
      expect(@vts_po.userMenu.userMenu_element.visible?).to eq(true)

      expected_content =[\
                        "Welcome SEVENTY PROVIDER",
                        time_date,
                        "You are not authorized to use this tool. Please contact your Clinical Applications Coordinator for assistance."
                        ]

      actual_content = @vts_po.landing.unauthorized_welcome_message_element.text.split("\n")

      expected_content.each_with_index do | expectedScreenRow, i |
        expect(actual_content[i].strip).to include(expectedScreenRow.strip)
      end
    end

    it "Verify Return to the VA Tool Set Home page" do
      @vts_po.landing.home_btn

      @vts_po.home.primary_header_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.primary_header).to eq("Home")
    end

  end

end
